<?php

defined('BASEPATH') or exit('No direct script access allowed');


class Task_manage_model extends CI_Model
{

    public $table_group         = 'task_manage_groups';

    public $table_milestones    = 'task_manage_milestones';

    public $table_tasks         = 'task_manage_tasks';

    public $table_custom_fields = 'task_manage_custom_fields_values';

    public function __construct()
    {
        parent::__construct();

        $this->table_group     = db_prefix().'task_manage_groups';

        $this->table_milestones     = db_prefix().'task_manage_milestones';

        $this->table_tasks          = db_prefix().'task_manage_tasks';

        $this->table_custom_fields  = db_prefix().'task_manage_custom_fields_values';

    }

    public function get_groups( $return_array = false )
    {

        if( $return_array )
            return $this->db->select('*')->from($this->table_group)->where('status',1)->get()->result_array();

        return $this->db->select('*')->from($this->table_group)->where('status',1)->get()->result();

    }

    public function get_group( $group_id = 0 )
    {

        return $this->db->select('*')->from($this->table_group)->where('id',$group_id)->get()->row();

    }

    public function get_item_milestones( $item_id = 0 )
    {

        return $this->db->select('*')->from($this->table_milestones)->where('group_id',$item_id)->order_by('milestone_order')->get()->result();

    }

    public function get_item_milestone( $item_id = 0 , $milestone_id = 0 )
    {

        return $this->db->select('*')->where('group_id',$item_id)->where('id',$milestone_id)->get($this->table_milestones)->row();

    }

    public function get_item_tasks( $item_id = 0 )
    {

        return $this->db->select('*')->where('group_id',$item_id)->order_by('task_order')->get($this->table_tasks)->result();

    }

    public function get_item_task( $item_id = 0 , $task_id = 0 )
    {

        return $this->db->select('*')->where('group_id',$item_id)->where('id',$task_id)->get($this->table_tasks)->row();

    }

    public function get_task_custom_fields( $task_id = 0 )
    {
        $this->db->where('relid', $task_id);

        return $this->db->get($this->table_custom_fields)->result();
    }

    public function save_custom_fields( $rel_id , $custom_fields )
    {

        $affectedRows = 0;

        foreach ( $custom_fields as $key => $fields )
        {

            foreach ($fields as $field_id => $field_value) {

                $this->db->where('relid', $rel_id);

                $this->db->where('fieldid', $field_id);


                $row = $this->db->get($this->table_custom_fields)->row();

                if (!is_array($field_value)) {

                    $field_value = trim($field_value);

                }

                if( !empty(  $row ) )
                {

                    $this->db->where('id', $row->id);

                    $this->db->update($this->table_custom_fields, [

                        'value' => $field_value,

                    ]);

                    if ($this->db->affected_rows() > 0) {

                        $affectedRows++;

                    }

                }
                else
                {

                    if ($field_value != '') {

                        $this->db->insert($this->table_custom_fields, [

                            'relid'   => $rel_id,

                            'fieldid' => $field_id,

                            'value'   => $field_value,

                        ]);

                        $insert_id = $this->db->insert_id();

                        if ($insert_id) {

                            $affectedRows++;

                        }

                    }

                }

            }

        }

        if ($affectedRows > 0) {

            return true;

        }



        return false;



    }


    /**
     * @note The project has been saved. Now, if there are groups assigned to the project, they will be checked and saved.
     */
    public function hook_project_saved( $project_id = 0 )
    {

        if( !empty( $project_id ) )
        {

            // task table column checking
            if ( !$this->db->field_exists('task_manage_task_id', db_prefix() .'tasks'))
            {

                $this->db->query('ALTER TABLE `'.db_prefix().'tasks`
                                ADD COLUMN `task_manage_task_id` int NULL AFTER `deadline_notified`;');

            }

            $project_info = $this->db->select('task_manage_groups')->from(db_prefix().'projects')->where('id',$project_id)->get()->row();

            if( !empty( $project_info->task_manage_groups ) )
            {

                $task_manage_groups = json_decode( $project_info->task_manage_groups , 1 );


                if( !empty( $task_manage_groups ) )
                {

                    // The first missions of all groups will be recorded.

                    foreach ( $task_manage_groups as $item_id )
                    {

                        // milestones creating
                        $milestone_converts_id = $this->create_milestones( $item_id , $project_id );

                        $group_tasks = $this->get_item_tasks( $item_id );

                        // Those with task_order values of 0 and 1 will be created automatically.
                        if( !empty( $group_tasks ) )
                        {

                            foreach ( $group_tasks as $group_task )
                            {

                                if( in_array( $group_task->task_order , [ 0 , 1 ] ) )
                                    $this->create_project_task( $project_id, $group_task , $milestone_converts_id );

                            }

                        }

                    } // end task group foreach


                }// end task group


            } // end id payment invoice id


        } // end id payment id

    }

    /**
     *
     * @note creating project milesitones
     *
     */
    private function create_milestones( $item_id , $project_id )
    {

        $project_milestone_table = db_prefix()."milestones";

        $milestone_converts_id = [];

        // milestone kaydediliyor
        $milestones = $this->get_item_milestones( $item_id );

        if( !empty( $milestones ) )
        {

            foreach ( $milestones as $milestone )
            {
                $prj_milestone_info = $this->db->select('id')
                                    ->from($project_milestone_table)
                                    ->where('project_id',$project_id)
                                    ->where('name',$milestone->milestone_name)
                                    ->get()
                                    ->row();


                if( empty( $prj_milestone_info ) )
                {

                    $this->db->insert( $project_milestone_table , [
                        'project_id' => $project_id ,
                        'name' => $milestone->milestone_name ,
                        'milestone_order' => $milestone->milestone_order ,
                        'color' => $milestone->milestone_color ,
                        'datecreated' => date('Y-m-d')
                    ] );

                    $milestone_converts_id[ $milestone->id ] = $this->db->insert_id();

                }
                else
                    $milestone_converts_id[ $milestone->id ] = $prj_milestone_info->id;

            }

        }

        return $milestone_converts_id;

    }

    /**
     * @note creating project tasks
     *
     * @param $project_id
     * @param $item_id assigned task group id
     * @param $task_id
     * @param $milestone_converts_id creating milestones ids
     * @return void
     */
    private function create_project_task( $project_id , $product_task , $milestone_converts_id )
    {


        $check_task_created = $this->db->select('id')
                                    ->from(db_prefix().'tasks')
                                    ->where_in('rel_type',['project','customer'])
                                    ->where('rel_id',$project_id)
                                    ->where('task_manage_task_id',$product_task->id)
                                    ->get()
                                    ->row();


        if( !empty( $check_task_created ) )
            return true;

        $current_date = date('Y-m-d H:i:s');

        $start_date = $due_date = $current_date;

        if( !empty( $product_task->start_date ) )
            $start_date = date('Y-m-d' , strtotime($current_date.' + '.$product_task->start_date.' days ') ) ;

        if( !empty( $product_task->due_date ) )
            $due_date   = date('Y-m-d' , strtotime($current_date.' + '.$product_task->due_date.' days ') ) ;

        $task_status_id = !empty( $product_task->task_status ) ? $product_task->task_status : 1 ;

        $rel_id = $project_id;

        if ( $product_task->related == 'customer' )
        {

            $project_info = $this->db->select('clientid')->from(db_prefix().'projects')->where('id',$project_id)->get()->row();

            if ( !empty( $project_info->clientid ) )
                $rel_id = $project_info->clientid;

        }

        $insert_task = [
            'name'      => $product_task->name ,
            'priority'  => $product_task->priority ,
            'dateadded' => $current_date ,
            'startdate' => $start_date ,
            'duedate'   => $due_date ,
            'status'    => $task_status_id ,
            'rel_id'    => $rel_id ,
            //'rel_type'  => 'project' ,
            'rel_type'  => $product_task->related ,
            'repeat_every'  => $product_task->repeat_every ,
            'description'   => $product_task->description ,
            'milestone'     => !empty( $milestone_converts_id[ $product_task->milestone ] ) ? $milestone_converts_id[ $product_task->milestone ] : 0 ,
            'task_manage_task_id' => $product_task->id ,


            'is_public' => $product_task->task_is_public ,
            'billable' => $product_task->task_is_billable ,
            'visible_to_client' => $product_task->task_visible_to_client

        ];

        $this->db->insert(db_prefix().'tasks',$insert_task);

        $project_task_id = $this->db->insert_id();

        if( $project_task_id )
        {

            /**
             * version 1.0.2
             * Project owners will be assigned to the task
             */
            if( !empty( $product_task->assign_project_owner ) && $product_task->assign_project_owner == 1 )
            {
                $project_owners = $this->db->select('staff_id')
                                            ->from(db_prefix().'project_members')
                                            ->where('project_id',$project_id)
                                            ->get()
                                            ->result();

                if( !empty( $project_owners ) )
                {

                    foreach ( $project_owners as $project_owner )
                    {

                        $this->db->insert(db_prefix().'task_assigned', [ 'staffid' => $project_owner->staff_id , 'taskid' => $project_task_id ] );

                    }

                }

            }


            if( !empty( $product_task->assignees ) )
            {
                $task_assignees = json_decode( $product_task->assignees );

                foreach ($task_assignees as $task_assignee)
                {

                    /**
                    $this->db->insert(db_prefix().'task_assigned', [ 'staffid' => $task_assignee , 'taskid' => $project_task_id ] );

                    */
                    $this->tasks_model->add_task_assignees([

                        'taskid'   => $project_task_id,

                        'assignee' => $task_assignee,

                    ]);

                }

            }

            if( !empty( $product_task->followers ) )
            {
                $task_followers = json_decode( $product_task->followers );

                foreach ($task_followers as $task_follower )
                {

                    /**
                    $this->db->insert(db_prefix().'task_followers', [ 'staffid' => $task_follower , 'taskid' => $project_task_id ] );
                     *
                     */

                    $this->tasks_model->add_task_followers([

                        'taskid'   => $project_task_id,

                        'follower' => $task_follower,

                    ]);


                }

            }

            if( !empty( $product_task->checklist_items ) )
            {
                $task_checks = json_decode( $product_task->checklist_items );

                foreach ($task_checks as $task_check )
                {

                    $tag_info = $this->db->select('description')->from(db_prefix().'tasks_checklist_templates')->where('id',$task_check)->get()->row();

                    if( !empty( $tag_info->description ) )
                        $this->db->insert(db_prefix().'task_checklist_items', [ 'dateadded' => $current_date , 'description' => $tag_info->description , 'taskid' => $project_task_id ] );

                }

            }

            $custom_fields = $this->get_task_custom_fields( $product_task->id );

            if( !empty( $custom_fields ) )
            {

                foreach ( $custom_fields as $custom_field )
                {

                    $this->db->insert(db_prefix().'customfieldsvalues', [
                        'relid'     => $project_task_id ,
                        'fieldid'   => $custom_field->fieldid ,
                        'fieldto'   => 'tasks' ,
                        'value'     => $custom_field->value ,
                    ] );

                } // end foreach custom fields

            } // end if custom fields

            if( !empty( $product_task->tags ) )
            {

                $tags = explode( ',' , $product_task->tags );

                foreach ( $tags as $tag_order => $tag )
                {
                    $tag_info = $this->db->select('id')->from(db_prefix().'tags')->where('name',$tag)->get()->row();

                    if( !empty( $tag ) && !empty( $tag_info->id ) )
                    {

                        $this->db->insert( db_prefix().'taggables' , [
                            'rel_id'    => $project_task_id ,
                            'rel_type'  => 'task' ,
                            'tag_id'    => $tag_info->id ,
                            'tag_order' => $tag_order ,
                        ] );

                    }

                }

            }


            if ( !empty( $product_task->task_created_project_status ) )
            {


                if ( !class_exists('Projects_model', false) )
                {

                    $this->load->model('projects_model');

                }

                $project_status_data = [
                    'status_id' => $product_task->task_created_project_status ,
                    'project_id' => $project_id ,
                    'notify_project_members_status_change' => 0 ,
                    'mark_all_tasks_as_completed' => 0 ,
                ];

                $this->projects_model->mark_as( $project_status_data );


            }


            hooks()->do_action('after_add_task', $project_task_id);


            hooks()->do_action('task_status_changed', ['status' => $task_status_id, 'task_id' => $project_task_id ]);


        } // end if project task id


        log_activity("Task Manage | $product_task->name task created for project [ $project_id ]");

    }

    // task completed
    public function hook_task_completed( $task_id = 0 )
    {

        $task_info = $this->db->select('task_manage_task_id,rel_type,rel_id')->from(db_prefix().'tasks')->where('id',$task_id)->get()->row();

        if( !empty( $task_info->task_manage_task_id ) )
        {

            if( in_array( $task_info->rel_type , [ 'project' , 'customer' ] ) )
            {

                $project_id = $task_info->rel_id;
                $task_manage_task_id = $task_info->task_manage_task_id;

                // The last created task record is checked.
                $task_manage_info = $this->db->select('task_order,group_id,task_completed_project_status')->from($this->table_tasks)->where('id',$task_manage_task_id)->get()->row();

                if( !empty( $task_manage_info ) )
                {

                    $task_order_id  = $task_manage_info->task_order;
                    $task_item_id   = $task_manage_info->group_id;


                    // Propject status change

                    if ( !empty( $task_manage_info->task_completed_project_status ) )
                    {


                        if ( !class_exists('Projects_model', false) )
                        {

                            $this->load->model('projects_model');

                        }

                        $project_status_data = [
                            'status_id' => $task_manage_info->task_completed_project_status ,
                            'project_id' => $project_id ,
                            'notify_project_members_status_change' => 0 ,
                            'mark_all_tasks_as_completed' => 0 ,
                        ];

                        $this->projects_model->mark_as( $project_status_data );


                    }



                    $continue_create_task = true;

                    if( $task_order_id > 0 )
                    {
                        // It will be checked whether all tasks in that group have been created. If all tasks are completed, the next group of tasks will occur.

                        $task_group_info = $this->db->select('id')->from($this->table_tasks)->where('group_id',$task_item_id)->where('task_order',$task_order_id)->get()->result();

                        if( !empty( $task_group_info ) )
                        {

                            foreach ( $task_group_info as $item_grp )
                            {
                                $group_other_task_info = $this->db->select('status')
                                                                ->from(db_prefix().'tasks')
                                                                ->where('task_manage_task_id',$item_grp->id)
                                                                ->where_in('rel_type',['project','customer'])
                                                                ->where('rel_id',$project_id)
                                                                ->get()
                                                                ->row();


                                if( !empty( $group_other_task_info ) && $group_other_task_info->status != 5 )
                                    $continue_create_task = false;

                            }

                        }


                    }




                    if( $continue_create_task )
                    {


                        $next_task_info = $this->db->select('task_order')
                                                ->from($this->table_tasks)
                                                ->where('task_order > '.$task_order_id , null , false )
                                                ->where('group_id',$task_item_id)
                                                ->order_by('task_order')
                                                ->get()
                                                ->row();

                        if( !empty( $next_task_info->task_order ) )
                        {

                            $next_order_group = $next_task_info->task_order;

                            $milestone_converts_id = $this->create_milestones( $task_item_id , $project_id );

                            $group_tasks = $this->get_item_tasks( $task_item_id );

                            // creating next group tasks
                            if( !empty( $group_tasks ) )
                            {

                                foreach ( $group_tasks as $group_task )
                                {

                                    if( $group_task->task_order == $next_order_group )
                                        $this->create_project_task( $project_id, $group_task , $milestone_converts_id );

                                }

                            }

                        }


                    }

                }


            }

        }


    }



    #Version 1.0.3

    /**
     * Returns the total number of tasks in the group
     */
    public function get_group_task_quantity( $item_id )
    {

        return $this->db->from($this->table_tasks)->where('group_id',$item_id)->count_all_results();

    }

    /**
     * return the total number of tasks created in the project
     */
    public function get_created_task_quantity_for_project( $project_id )
    {

        return $this->db->from(db_prefix().'tasks')
                            ->where('COALESCE( task_manage_task_id , 0 ) > 0 ',null,false)
                            ->where_in('rel_type',['project','customer'])
                            ->where('rel_id',$project_id)
                            ->count_all_results();

    }

    public function get_project_tasks( $project_id )
    {

        return $this->db->select('name,status,task_manage_task_id')
                        ->from(db_prefix().'tasks')
                        ->where('COALESCE( task_manage_task_id , 0 ) > 0 ',null,false)
                        ->where_in('rel_type',['project','customer'])
                        ->where('rel_id',$project_id)
                        ->get()
                        ->result();

    }


    /**
     * @Version 1.0.4
     */
    public function get_pipeline_groups()
    {
        return $this->db->select('id,group_name')
                            ->from($this->table_group)
                            ->where('id IN ( 
                                                            SELECT group_id 
                                                            FROM '.db_prefix().'task_manage_tasks
                                                            WHERE id IN ( SELECT t.task_manage_task_id FROM '.db_prefix().'tasks t WHERE t.status != 5 AND COALESCE( t.task_manage_task_id , 0 ) > 0 ) 
                                                            GROUP BY group_id 
                                                            )',null,false)
                            ->order_by('group_name')
                            ->get()
                            ->result();
    }

    public function get_pipeline_group_orders( $group_id )
    {

        $tasks = $this->get_item_tasks( $group_id );

        $group_tasks = [];

        foreach ( $tasks as $task )
        {

            $group_tasks[ $task->task_order ] = $task->task_order ;

        }

        return $group_tasks;

    }


}

